require( "scripts/style.lua" )

HeaderFont = {
  bigButtonFont,
  50,
  DarkRedColor
};

TableInfoFont = {
  standardFont,
  30,
 BlackColor
};

ErrorFont = {
  standardFont,
  24,
  BlackColor
};

AccountFont = {
  standardFont,
  20,
  BlackColor
};
AccountFontEdit = {
  standardFont,
  20,
  BlueColor
};

AccountFontScore = {
  standardFont,
  24,
  DarkRedColor
};

ScoreFont = {
  standardFont,
  18,
  BlackColor
};

kPlayerNameY = 100;
kScoreY = 150;
kYourPFAccountY = 185;
kAccountNameY = 200;
kPasswordY = 245;
kRememberY = 305;

HiscoreSubmitLegal = {
  standardFont,
  14,
  BlackColor
};


kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
    kPrivacyLabel = 'privacy_info';
end


function SwitchModes( submit )
    
    local localHS = IsEnabled(kHiscoreLocalOnly);
    local anonHS = IsEnabled(kHiscoreAnonymous);
    local fullHS = (not localHS) and (not anonHS);

    if submit then
        DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
    else
        DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
    end

    --EnableWindow("header",not submit);
    EnableWindow("headershadow",not submit);
    EnableWindow("playertext", not submit);
    EnableWindow("yourscore", not submit);
    EnableWindow("eligiblescore", not submit);
    EnableWindow("yourpfaccount", not submit and fullHS);
    EnableWindow("nametext", not submit and fullHS);
    EnableWindow("passtext", not submit and fullHS);

    EnableWindow("nameeditbox", not submit );
    EnableWindow("accounteditbox", not submit and fullHS);
    EnableWindow("passeditbox", not submit and fullHS);
    EnableWindow("remember", not submit and fullHS);

    EnableWindow("submittoserver", not submit);
    EnableWindow("submitcancel", not submit);
    EnableWindow("submitconnect", submit);
    EnableWindow("policy", not submit);
end

MakeDialog
{
    name="hiscoresubmitscreen",
    Bitmap
    {
        name="grayimage",
        image="backgrounds/shadow.png",
        alpha=true,
        x=0,
        y=0
    };
        
    Bitmap
    { 
        image="backgrounds/submit_hs.png",  
        x=101,--kCenter,
        y=10,--kCenter,

        SetStyle(DefaultStyle);
        Text
        {
            font = HeaderFont,
            name = "header",
            x=0,y=5,w=kMax,h=kMax,
            flags = kHAlignCenter + kVAlignTop,
            label = "submitglobal"
        };
        
        Text
        {
            font = AccountFont,
            name = "playertext",
            x=160,y=kPlayerNameY-10,w=145,h=kMax,
            --flags = kHAlignRight + kVAlignTop,
            label = "playerlabel"
        };
        
        Text
        {
            font = AccountFont,
            name = "yourscore",
	        x = 119,
	        y = 150,
	        w = 137,
	        h = 24,
            flags = kHAlignRight + kVAlignTop,
            label = "scorelabel"
        };
        
        Text
        {
            font = AccountFontScore,
            name = "eligiblescore",
            x=319,y=kScoreY,w=100,h=kMax,
            flags = kHAlignLeft + kVAlignTop,
            label = ""
        };
        
        Text
        {
            font = ScoreFont,
            name = "yourpfaccount",
	        x = 125,
	        y = 185,
	        w = 330,
	        h = 24,
            flags = kHAlignCenter + kVAlignTop,
            label = "yourpfaccount"
        };
        
        Text
        {
            font = AccountFont,
            name = "nametext",
	        x = 160,
	        y = 200,
	        w = 120,
	        h = 24,
            --flags = kHAlignRight+ kVAlignTop,
            label = "namelabel"
        };
        
        Text
        {
            font = AccountFont,
            name = "passtext",
            x=160,y=kPasswordY,w=145,h=kMax,
            --flags = kHAlignRight + kVAlignTop,
            label = "passwordlabel"
        };
        
        Text
        {
            font = TableInfoFont,
            name = "submitconnect",
            x=0,y=0,w=kMax,h=kMax,
            flags = kHAlignCenter + kVAlignCenter,
            label = "connectingtoserver"
        };
        
        Text
        {
            font = ErrorFont,
            name = "submiterror",
            x=130,y=0,w=kMax-150,h=kMax,
            flags = kHAlignCenter + kVAlignCenter,
            label = "Error Message"
        };
--[[        
        Text
        {
            x = 20, w = kMax-20,
            y = 400, h = kMax,
            font = HiscoreSubmitLegal;
            flags = kHAlignLeft + kVAlignTop,
            label = kPrivacyLabel
        };
--]]
        

        Bitmap
        {
            name="nameeditbox",
            image="backgrounds/textfield.png",
            x=145,
            y=kPlayerNameY,
            
            TextEdit
            {
                font = AccountFontEdit,
                name = "nameedit",
                label = gNameEdit,
                x=8,y=14,w=kMax-3,h=kMax,
                length=20,
                ignore = kIllegalNameChars
                
            };
        };
        
        Bitmap
        {
            name="accounteditbox",
            image="backgrounds/textfield.png",
            x=145,
            y=kAccountNameY+10,
            
            TextEdit
            {
                font = AccountFont,
                name = "accountedit",
                label= gAccountEdit,
                x=8,y=14,w=kMax,h=kMax,
                length=26,
                ignore = kIllegalNameChars
                
            };
        };
        
        Bitmap
        {
            name="passeditbox",
            image="backgrounds/textfield.png",
            x=145,
            y=kPasswordY+10,
            
            TextEdit
            {
                font = AccountFont,
                name = "passedit",
                label= gPassEdit,
                x=8,y=14,w=kMax,h=kMax,
                password = true,
                length=26
                
            };
        };
        
        SetStyle( CheckboxButtonStyle ),
        Button
        {
            x=160, y=kRememberY,

            name="remember",
            type = kToggle,
            w=250,
            --scale=0.5,
            rollover = "",
            drop = false,
            sound = "audio/sfx/checkbox.ogg",
            Text
            {
                font = AccountFont,
                name = "rememberlabel",
	            x = 25,
	            y = 4,
	            w = 280,
	            h = 25,
                flags = kHAlignLeft + kVAlignTop,
                label="rememberpfaccount",
            };
        };
        
        SetStyle( ButtonStyle ),	
		Text
		{
			font = AccountFont,
			name = "privasy_text",
	        x = 147,
	        y = 357,
	        w = 290,
	        h = 90,
			flags = kHAlignCenter + kVAlignTop,
			label="privacy",
		};		

    };
    SetStyle( ButtonStyle ),

	Button
	{
		x=235,
		y=534,

		name="submittoserver",
		label="submit",
		type = kPush,
		default= true, -- this should be the default button (on enter)
		graphics = StButtonGraphicsSm,
		font = MenuButtonFont;
		command = 
			function()
				MayBeSubmit = nil;
				name = GetLabel("nameedit");
				account = GetLabel("accountedit");
				pass = GetLabel("passedit");
				remember = GetButtonToggleState("remember");
				SubmitToServer(name,account,pass,remember);
			end
	},

    
    Button
    {
        x=410, y=534, --kMax-50,
        graphics = StButtonGraphicsSm,
        font = MenuButtonFont;
        name="submitcancel",
        label="cancel",
        type = kPush,
        command = 
            function()
                PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
            end
    };
    
    Button
    {
        x=412, y=534,
        font = MenuButtonFont;
        graphics = StButtonGraphicsSm,
        name="submiterrorok",
        label="ok",
        type = kPush,
        command=
            function()
                EnableWindow("submiterrorok",false);
                EnableWindow("submiterror",false);
                SwitchModes(false);
            end
    };
    
    Button
    {
        x=0,
        y=0,
        w=0,
        h=0,
        graphics={},
        name="privacybutton",
        command = 
            function()
                if (IsEnabled(kHiscoreAnonymous)) then
                    DisplayDialog { 
                        "scripts/ok.lua", 
                        body ="privacy_anon",
                        title = ""
                    };
                else
                    LaunchPrivacyPolicy();
                end
            end
    };
    
}
SetLabel("eligiblescore",""..gEligibleScore);
EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");
